/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_10; import java.util.Vector; 
import djbuch.kapitel_06.DemoTools;
import djbuch.kapitel_06.GC;
import lotus.domino.*;

/**
 * Mit Ausfhrungsdauer fr verschiedene Suchoperationen und Loopdauer ber 
 * DocumentCollection, ViewEntryCollection und View
 * 
 ***************************************** 
 * Beispielergebnis fr DIIOP Ausfhrung:
 ***************************************** 
Aufrumen: Lsche 202 Dokumente.
Erzeuge 1010 neue Dokumente.
FT Index aktualisieren.

SETUP:
Zu ladende Items pro Dokument: 8
Anzahl der Suchoperationen pro Suche: 5
Anzahl der Dokumente: 1010
Ausfhrungsort der Session: Auf Server CN=Java/O=DJBUCH

Ergebnis:
Loop durch DocumentCollection:	2640ms / Treffer: 111
Loop durch ViewEntryCollection:	2735ms / Treffer: 111
Loop durch ViewEntryCollection mit getItemValue: 2687ms / Treffer: 111
Loop durch View per getFirst/NextDocument (1010 Docs) 25875ms
Im Vergleich DocumentCollection (1010 Docs) 22359ms

 ***************************************** 
 * Beispielergebnis fr lokale Ausfhrung
 ***************************************** 
Aufrumen: Lsche 1010 Dokumente.
Erzeuge 1010 neue Dokumente.
FT Index aktualisieren.

SETUP:
Zu ladende Items pro Dokument: 8
Anzahl der Suchoperationen pro Suche: 5
Anzahl der Dokumente: 1010
Ausfhrungsort der Session: Lokal

Ergebnis:
Loop durch DocumentCollection:	234ms / Treffer: 111
Loop durch ViewEntryCollection:	297ms / Treffer: 111
Loop durch ViewEntryCollection mit getItemValue: 390ms / Treffer: 111
Loop durch View per getFirst/NextDocument (1010 Docs) 2126ms
Im Vergleich DocumentCollection (1010 Docs) 1703ms

@author Thomas Ekert
 */
public class CollectionComparison extends NotesThread{

	private static final String PASSWORD = "geheim";
	private static final String HOST = null;//"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null;//"Thomas Ekert/DJBUCH";	//null fr lokale Session

	private static View view = null;
	private static int viewWidth = 1;
	public static void main(String[] args) {
		CollectionComparison cc = new CollectionComparison();
		cc.start();
	}
	public void runNotes() {
		Document doc = null;
		Database db = null;
		Session session = null;
		DocumentCollection dc = null;
		ViewEntryCollection vec =null;
		try {
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			db = session.getDatabase("", "djbuch/djbuch.nsf");
			if (DO_STARTUP) DemoTools.startup (db, NUM_OF_DOCS);
			view = db.getView(LOOKUP_VIEW);
			viewWidth = view.getColumnCount();
			view.refresh();
			/*
			//Demo - leere vec
			Vector v=new Vector();
			vec = view.getAllEntriesByKey("~~~gibtsnicht~~~",true);
			vec.addEntry (view.getFirstDocument());
			printViewEntryCollection(vec,true);
			*/
			//Demo - geschw. viewentry versus doccollection
			long size = 0, size1=0, size2=0;
			long L = System.currentTimeMillis();
			long time1=0, time2=0, time3=0;
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				String index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				dc=view.getAllDocumentsByKey(DemoTools.ANIMAL_A + index,EXACT_SEARCH);
				size+=dc.getCount();
				printDocumentCollection(dc);
				GC.recycle(dc);
			}
			time1=System.currentTimeMillis()-L;
			size1=size/SEARCH_COUNT;
			size=0;
			L=System.currentTimeMillis();
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				String index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				vec=view.getAllEntriesByKey(DemoTools.ANIMAL_A + index,EXACT_SEARCH);
				size+=vec.getCount();
				printViewEntryCollection(vec,true);
				GC.recycle(vec);
			}
			time2=System.currentTimeMillis()-L;
			size2=size/SEARCH_COUNT;
			size=0;
			L=System.currentTimeMillis();
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				String index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				vec=view.getAllEntriesByKey(DemoTools.ANIMAL_A + index,EXACT_SEARCH);
				size+=vec.getCount();
				printViewEntryCollection(vec,false);
				GC.recycle(vec);
			}
			System.out.println ("\nSETUP:");
			System.out.println ("Zu ladende Items pro Dokument: " + DOCUMENT_LOAD);
			System.out.println ("Anzahl der Suchoperationen pro Suche: " + SEARCH_COUNT);
			System.out.println ("Anzahl der Dokumente: " + ((int)(NUM_OF_DOCS*1.01)));
			System.out.println ("Ausfhrungsort der Session: " + (HOST==null&&USER==null?"Lokal":"Auf Server " + session.getServerName()));
			
			System.out.println ("\nErgebnis:");
			System.out.println ("Loop durch DocumentCollection:\t" + (time1) + "ms / Treffer: " + (size1));
			System.out.println ("Loop durch ViewEntryCollection:\t" + (time2) + "ms / Treffer: " + (size2));
			System.out.println ("Loop durch ViewEntryCollection mit getItemValue: " + (System.currentTimeMillis()-L) + "ms / Treffer: " + (size/SEARCH_COUNT));
			size=0;
			//Vergleich view / dc
			L=System.currentTimeMillis();
			for (int i = 0; i < SEARCH_COUNT; i++) {
				printView (view);
			};
			L=System.currentTimeMillis()-L;
			System.out.println ("Loop durch View per getFirst/NextDocument (" + view.getAllEntries().getCount() + " Docs) " + L + "ms");
			dc = view.getAllDocumentsByKey("");
			L=System.currentTimeMillis();
			for (int i = 0; i < SEARCH_COUNT; i++) {
				printDocumentCollection(dc);
			};
			L=System.currentTimeMillis()-L;
			System.out.println ("Im Vergleich DocumentCollection (" + dc.getCount() + " Docs) " + L + "ms");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println ("id = " + (e instanceof NotesException?""+((NotesException)e).id:""));
		} finally {
			GC.recycle(doc);
			GC.recycle(dc);
			GC.recycle(vec);
			GC.recycle(view);
			GC.recycle(db);
			GC.recycle(session);
		}
		
	}

	
	private static final void printViewEntryCollection (ViewEntryCollection vec, boolean fast) {
		ViewEntry entry = null, nextEntry = null;
		String tmp="";
		try {
			entry = vec.getFirstEntry();
			while (entry != null) {
				if (entry.isDocument()) {
					Vector v=entry.getColumnValues();
					Document myDoc=entry.getDocument();
					for (int i = 0; i < DOCUMENT_LOAD; i++) {
						if (fast) {
							tmp = "\tDokument: " + v.elementAt(i%viewWidth);
						}else {
							tmp = "\tDokument: " + myDoc.getItemValueString("Item_" + i);
						}
					}
					GC.recycle(myDoc);
				}
				if (!SILENT) System.out.println (tmp);
				/*
				if (entry.isCategory()) {
					tmp = "Kategorie: " + entry.getColumnValues().elementAt(0);
				}
				if (!silent) System.out.println (tmp);
				if (entry.isTotal()) {
					tmp="Total: " + entry.getColumnValues().elementAt(1);
				}
				if (!silent) System.out.println (tmp);
				if (entry.isConflict()) {
					tmp="\t\tSpeicherkonflikt: " + entry.getDocument().getItemValueString("F_titel");
				}
				if (!silent) System.out.println (tmp);*/
				nextEntry = vec.getNextEntry();
				GC.recycle(entry);
				entry=nextEntry;
			}
		} catch (NotesException e) {
			e.printStackTrace();
		} finally {
			GC.recycle (entry);
			GC.recycle (nextEntry);
		}
	}
	
	private static final void printDocumentCollection (DocumentCollection dc) {
		Document doc = null, nextDoc = null;
		String tmp="";
		try {
			doc = dc.getFirstDocument();
			while (doc != null) {
				tmp="\tDokument: " + doc.getItemValueString("F_titel");
				if (!SILENT) System.out.println (tmp);
				for (int i = 0; i < DOCUMENT_LOAD; i++) {
					tmp="\tDokument: " + doc.getItemValueString("Item_" + i);
					if (!SILENT) System.out.println (tmp);
				}
				nextDoc = dc.getNextDocument();
				GC.recycle(doc);
				doc=nextDoc;
			}
		} catch (NotesException e) {
			e.printStackTrace();
		} finally {
			GC.recycle (doc);
			GC.recycle (nextDoc);
		}
	}
	
	private static final void printView (View v) {
		Document doc = null, nextDoc = null;
		String tmp="";
		try {
			doc = v.getFirstDocument();
			while (doc != null) {
				tmp="\tDokument: " + doc.getItemValueString("F_titel");
				if (!SILENT) System.out.println (tmp);
				for (int i = 0; i < DOCUMENT_LOAD; i++) {
					tmp="\tDokument: " + doc.getItemValueString("Item_" + i);
					if (!SILENT) System.out.println (tmp);
				}
				nextDoc = v.getNextDocument(doc);
				GC.recycle(doc);
				doc=nextDoc;
			}
		} catch (NotesException e) {
			e.printStackTrace();
		} finally {
			GC.recycle (doc);
			GC.recycle (nextDoc);
		}
	}
	private static final int NUM_OF_DOCS = 1000;			// Anzahl neuer Dokumente
	private static final int SEARCH_COUNT = 5;			// Anzahl der Suchoperationen UND
														// Teil des Suchwortes (bei
														// SEARCH_COUNT==9 wird nach
														// XXX0...XXX9 gesucht
	private static final boolean EXACT_SEARCH = false; 	// Soll eine exakte Suche durchgefhrt werden?

	private static final boolean DO_STARTUP = true;		// Dokumente neu erzeugen??
	private static final int DOCUMENT_LOAD = 8;			// Wie viele Items sollen beim Lasttest gelesen werden? 
														
	private static final int SEARCH_WIDTH = 1;			// Spezialisierung des Suchwortes (nur fr RANDOM)
														// SEARCH_WIDTH == 1 sucht nach XXX0..XXX9
														// SEARCH_WIDTH == 3 sucht nach XXX001...XXX999
	private static final String LOOKUP_VIEW = "V_lookup_k6"; // V_lookup_wide_k6 oder V_lookup_k6
	private static final boolean SILENT = true;			// Ausgaben werden nicht gemacht.

}
